# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Union
from typing_extensions import Literal, Required, Annotated, TypedDict

from .._types import Base64FileInput
from .._utils import PropertyInfo
from .._models import set_pydantic_config
from .document_mime_type_param import DocumentMimeTypeParam

__all__ = ["DocumentContentParam"]


class DocumentContentParam(TypedDict, total=False):
    """A document content block."""

    type: Required[Literal["document"]]

    data: Annotated[Union[str, Base64FileInput], PropertyInfo(format="base64")]
    """The document content."""

    mime_type: DocumentMimeTypeParam
    """The mime type of the document."""

    uri: str
    """The URI of the document."""


set_pydantic_config(DocumentContentParam, {"arbitrary_types_allowed": True})
